
Class Level

	Public

	Property MainCamera:GameCamera ()
		Return camera
	End
	
	Property Player:Rocket ()
		Return player
	End
		
	Property SpaceGemCount:Int ()
		Return space_gem_count
	End
	
	Property SpaceGemsCollected:Int ()
		Return space_gems_collected
	End

	Property SpaceGemsTotal:Int ()
		Return space_gems_total
	End

	Method New (level:String)

		camera = New GameCamera (App.ActiveWindow.Rect)
		
		player = New Rocket (0.0, 15.0, 0.0, 1.2, 4.0, 10.0)

		' Sample hard-coded level...
		
		light					= New Light
		light.CastsShadow		= True
		light.Range				= 1000
		light.Color = Color.White
		light.Move (-25, 100, 50)

		terrain = New PhysicsTerrain ()
		
		ground = terrain.LoadTerrain (level, CheckerPixmap (Color.Green * 0.5, Color.SeaGreen * New Color (1.0, 1.2, 0.75)))
		
		ground.Move (0, -10, 0)

		light.PointAt (ground)

		' Start pad, no gem:
		
		New Pad (0.0, 10.0, 0.0)
		
		' Others (skipped param is x/z size)...
		
		New Pad (-20.0, -9.0, 10.0,, Color.Red)
		SpaceGemAdded ()
		
		New Pad (40.0, -9.0, 25.0,, Color.Yellow)
		SpaceGemAdded ()
		
		New Pad (80.0, -9.0, 75.0,, Color.Orange)
		SpaceGemAdded ()
		
		New Pad (0.0, -9.0, 50.0,, Color.Green)
		SpaceGemAdded ()
		
		New Pad (100.0, 50.0, 240.0,, Color.Magenta)
		SpaceGemAdded ()
		
		New Pad (-105.0, 54.5, 235.0,, Color.Gold)
		SpaceGemAdded ()
		
		New Pad (-230.0, 9.0, 157.0,, Color.Violet)
		SpaceGemAdded ()
		
		New Pad (111.0, -9, -160.0,, Color.Black)
		SpaceGemAdded ()
		
		New Pad (-70.0, 37.5, -31.0,, Color.HotPink)
		SpaceGemAdded ()
		
		New Pad (93.0, 38.0, -365.0,, Color.Lime)
		SpaceGemAdded ()
		
		space_gems_total = SpaceGemCount
		
	End

	Method Complete:Bool ()
		If SpaceGemsCollected = SpaceGemsTotal
			Return True
		Else
			Return False
		Endif
	End
	
	Method Reset ()

		SmokeParticle.Clear ()
		PhysicsTri.Clear ()
		
		player.CurrentOrb?.Destroy ()
		player.CurrentOrb = Null

		player.Destroy ()
		player = New Rocket (0.0, 15.0, 0.0, 1.2, 4.0, 10.0)

		camera.Reset ()
		
		Game.AssignGlobalRefs ()
		
	End
	
	Method SpaceGemCollected ()
		space_gems_collected = space_gems_collected + 1
	End
	
	Method SpaceGemAdded ()
		space_gem_count = space_gem_count + 1
	End
	
	Private

	Field camera:GameCamera
	Field player:Rocket			' TODO: Move to Rocket class

	Field space_gem_count:Int
	Field space_gems_collected:Int ' TEMP!
	Field space_gems_total:Int
	
	Field light:Light

	Field terrain:PhysicsTerrain
	
	Field ground:Model
	Field ground_pixels:Pixmap

	Field heightmap:Pixmap
	Field terrain_material:PbrMaterial

End
